﻿'版权所有 (C) Microsoft Corporation。保留所有权利。

Imports System.IO
Imports System.Xml
Imports System.Reflection

' 此示例说明的是对 System.Reflection 和 System.Xml.XLinq 中的
' 组件执行的查询。还会生成一个 HTML 文档，该文档概要介绍 
' 给定程序集(此例中为 System.Xml.Linq.dll)的公用 API。


Friend Module Program

    Const HtmlFile As String = "System.Xml.Linq.html"

    Public Sub Main()

        ' 获取要反射的程序集路径和名称
        Dim assembly As Assembly = assembly.GetAssembly(GetType(XDocument))
        Dim AssemblyFile As String = assembly.CodeBase

        ' 对程序集进行反射
        Dim reflector As New Reflector()
        reflector.Reflect(AssemblyFile)

        ' 生成 HTML 文档
        Dim settings As New XmlWriterSettings()
        settings.OmitXmlDeclaration = True
        settings.Indent = True
        Dim writer As XmlWriter = XmlWriter.Create(HtmlFile, settings)
        reflector.Transform(writer)
        writer.Close()

        ' 显示 HTML 文档
        Dim fileInfo As New FileInfo(HtmlFile)
        If fileInfo.Exists Then Process.Start("iexplore.exe", fileInfo.FullName)
    End Sub
End Module